<?php
#	SonicCampGuard
#
#	Copyright (c) 2024 Bundeswehr
#	Diese Anwendung wurde von Cedric Prietz entwickelt.
#	E-Mail: CedricPrietz@bundeswehr.org
#	App: 90-8303-54618
#
#	Letzte Änderung: 22.01.2025

require_once $_SERVER['DOCUMENT_ROOT'] . '/function.inc.php';
pageName('Identitäten');
requireLogin();
requireRole(['Bearbeiter', 'Administrator']);
showSessionAlert();

initializeDatabaseConnection();

include($_SERVER['DOCUMENT_ROOT'] . '/header.inc.php');
?>

<div class="row">

    <div class="position-absolute start-0 end-0">

        <div class="col-12">

            <div class="d-flex justify-content-between align-items-center flex-wrap grid-margin">
                <div>
                    <h4 class="mb-md-0">Identitäten</h4>
                    <span class="text-secondary">Liste</span>
                </div>
                <div class="d-flex align-items-center flex-wrap text-nowrap">

                    <div class="dropdown">
                        <button class="btn btn-primary dropdown-toggle btn-icon-text me-2" type="button"
                            id="dropdownMenuButton" data-bs-toggle="dropdown" aria-haspopup="true"
                            aria-expanded="false">
                            <i class="btn-icon-prepend mdi mdi-account-plus"></i> Neu
                        </button>
                        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            <a class="dropdown-item" href="/identities/add-identity-military">Soldat</a>
                            <a class="dropdown-item" href="/identities/add-identity-civil">Zivilist</a>
                            <a class="dropdown-item" href="/identities/add-identity-local">Ortskraft</a>
                            <a class="dropdown-item" href="/identities/add-identity-guest">Gast</a>
                        </div>
                    </div>

                    <div class="dropdown" data-bs-toggle="tooltip" data-bs-placement="top" title="Exportieren">
                        <button class="btn btn-success btn-icon me-2" type="button" id="dropdownMenuButton"
                            data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="mdi mdi-download"></i>
                        </button>
                        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            <a class="dropdown-item" href="#">PDF <span style="margin-left:15px;font-size:10px;"
                                    class="text-warning">NICHT VERFÜGBAR</span></a>
                            <a class="dropdown-item" href="#">EXCEL <span style="margin-left:15px;font-size:10px;"
                                    class="text-warning">NICHT VERFÜGBAR</span></a>
                        </div>
                    </div>

                    <a href="/identities/identitiesboard" class="btn btn-secondary btn-icon mb-md-0"
                        data-bs-toggle="tooltip" data-bs-placement="top" title="Zurück">
                        <i class="mdi mdi-arrow-left-top"></i>
                    </a>
                </div>
            </div>

        </div>

        <div class="col-12 col-md-12 col-xl-12 grid-margin">
            <div class="card">

                <div class="card-header">
                    <ul class="nav nav-tabs card-header-tabs" id="lineTab" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" id="home-line-tab" data-bs-toggle="tab"
                                href="#identities-military" role="tab" aria-controls="Militärisch"
                                aria-selected="true">Soldaten</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="profile-line-tab" data-bs-toggle="tab" href="#identities-civil"
                                role="tab" aria-controls="Zivil" aria-selected="false">Zivilisten</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="contact-line-tab" data-bs-toggle="tab" href="#identities-local"
                                role="tab" aria-controls="Ortskräfte" aria-selected="false">Ortskräfte</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="contact-line-tab" data-bs-toggle="tab" href="#identities-guest"
                                role="tab" aria-controls="Gäste" aria-selected="false">Gäste</a>
                        </li>
                    </ul>
                </div>

                <div class="card-body">

                    <div class="tab-content" id="lineTabContent">

                        <div class="tab-pane show active" id="identities-military" role="tabpanel"
                            aria-labelledby="home-line-tab">

                            <div class="table-responsive">
                                <table id="dTableIdentitiesMilitary" width="100%" class="table"
                                    style="text-align: left;">
                                    <thead>
                                        <tr>
                                            <th class="text-start">Nachname</th>
                                            <th class="text-start">Vorname</th>
                                            <th class="text-start">Dienstgrad</th>
                                            <th class="text-start"><i class="mdi mdi-airplane-landing"
                                                    style="margin-right: .5rem;"></i> IN</th>
                                            <th class="text-start"><i class="mdi mdi-airplane-takeoff"
                                                    style="margin-right: .5rem;"></i> OUT</th>
                                            <th class="text-start"><i class="mdi mdi-briefcase"
                                                    style="margin-right: .5rem;"></i> Dienstposten</th>
                                            <th class="text-start"><i class="mdi mdi-card-text-outline"
                                                    style="margin-right: .5rem;"></i> Karte</th>
                                            <th><i class="mdi mdi-button-cursor" style="margin-right: .5rem;"></i>
                                                Optionen
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sql = "SELECT * FROM Identities WHERE Type = 'Military'";
                                        $stmt = $pdo->query($sql);
                                        $IdentitiesMilitary = $stmt->fetchAll();

                                        if ($IdentitiesMilitary) {
                                            foreach ($IdentitiesMilitary as $IdentityMilitary) {

                                                echo "<tr>";
                                                echo "<td class='text-start fw-bold'>" . htmlspecialchars($IdentityMilitary['Surname']) . "</td>";
                                                echo "<td class='text-start fw-bold'>" . htmlspecialchars($IdentityMilitary['Givenname']) . "</td>";
                                                echo "<td class='text-start'>" . htmlspecialchars($IdentityMilitary['Rank']) . "</td>";
                                                echo "<td class='text-start'>" . htmlspecialchars($IdentityMilitary['IdentityIN']) . "</td>";

                                                $targetDate = $IdentityMilitary['IdentityOUT'];
                                                $currentDate = new DateTime();
                                                $endDate = new DateTime($targetDate);
                                                $interval = $currentDate->diff($endDate);
                                                $daysDifference = (int) $interval->format('%r%a');

                                                if ($daysDifference < 0) {
                                                    $outClass = 'fw-bold text-danger';
                                                    $outText = "Abgeflogen";
                                                } elseif ($daysDifference >= 0 && $daysDifference < 10) {
                                                    $outClass = 'fw-bold text-warning';
                                                    $outText = "Noch <b>" . $daysDifference + 1 . "</b> Tage";
                                                } else {
                                                    $outClass = '';
                                                    $outText = "Noch <b>" . $daysDifference + 1 . "</b> Tage";
                                                }

                                                echo "<td class='text-start $outClass' data-bs-toggle='tooltip' data-bs-html='true' data-bs-placement='left' title='" . $outText . "'>" . htmlspecialchars($IdentityMilitary['IdentityOUT']) . "</td>";

                                                echo "<td class='text-start'>";

                                                if (getPositionDetails('OwnerAccessCard', $IdentityMilitary['AccessCard'], 'ID')) {
                                                    echo "<a href='/identities/position?id=" . getPositionDetails('OwnerAccessCard', $IdentityMilitary['AccessCard'], 'ID') . "' class='fw-bold'>" . getPositionDetails('OwnerAccessCard', $IdentityMilitary['AccessCard'], 'PositionName') . " - " . getPositionDetails('OwnerAccessCard', $IdentityMilitary['AccessCard'], 'Department') . "</a>";
                                                } elseif (getPositionDetails('SuccessorAccessCard', $IdentityMilitary['AccessCard'], 'ID')) {
                                                    echo "<a href='/identities/position?id=" . getPositionDetails('SuccessorAccessCard', $IdentityMilitary['AccessCard'], 'ID') . "' class='fw-bold'>" . getPositionDetails('SuccessorAccessCard', $IdentityMilitary['AccessCard'], 'PositionName') . " - " . getPositionDetails('SuccessorAccessCard', $IdentityMilitary['AccessCard'], 'Department') . "</a>";
                                                }

                                                echo "</td>";

                                                echo "<td class='text-start'>";
                                                if ($IdentityMilitary['AccessCard']) {
                                                    echo "<span class='btn btn-sm btn-outline-secondary me-2'><i class='btn-icon-prepend mdi mdi-credit-card-outline me-1'></i>" . $IdentityMilitary['AccessCard'] . "</span>";
                                                }
                                                echo "</td>";

                                                echo "<td class='text-end'><a href='/identities/identity?id=" . htmlspecialchars($IdentityMilitary['ID']) . "' class='btn btn-sm btn-inverse-light btn-icon-text' style='margin: 0px;'><i class='mdi mdi-text-box-edit'></i> Bearbeiten</a></td>";
                                                echo "</tr>";
                                            }
                                        }

                                        ?>
                                    </tbody>
                                </table>
                            </div>

                        </div>

                        <div class="tab-pane" id="identities-civil" role="tabpanel" aria-labelledby="profile-line-tab">

                            <div class="table-responsive">
                                <table id="dTableIdentitiesCivil" width="100%" class="table" style="text-align: left;">
                                    <thead>
                                        <tr>
                                            <th class="text-start">Nachname</th>
                                            <th class="text-start">Vorname</th>
                                            <th class="text-start"><i class="mdi mdi-airplane-landing"
                                                    style="margin-right: .5rem;"></i> IN</th>
                                            <th class="text-start"><i class="mdi mdi-airplane-takeoff"
                                                    style="margin-right: .5rem;"></i> OUT</th>
                                            <th class="text-start"><i class="mdi mdi-briefcase"
                                                    style="margin-right: .5rem;"></i> Dienstposten</th>
                                            <th class="text-start"><i class="mdi mdi-card-text-outline"
                                                    style="margin-right: .5rem;"></i> Karte</th>
                                            <th><i class="mdi mdi-button-cursor" style="margin-right: .5rem;"></i>
                                                Optionen
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sql = "SELECT * FROM Identities WHERE Type = 'Civil'";
                                        $stmt = $pdo->query($sql);
                                        $IdentitiesCivil = $stmt->fetchAll();

                                        if ($IdentitiesCivil) {
                                            foreach ($IdentitiesCivil as $IdentityCivil) {

                                                echo "<tr>";
                                                echo "<td class='text-start fw-bold'>" . htmlspecialchars($IdentityCivil['Surname']) . "</td>";
                                                echo "<td class='text-start fw-bold'>" . htmlspecialchars($IdentityCivil['Givenname']) . "</td>";
                                                echo "<td class='text-start'>" . htmlspecialchars($IdentityCivil['IdentityIN']) . "</td>";

                                                $targetDate = $IdentityCivil['IdentityOUT'];
                                                $currentDate = new DateTime();
                                                $endDate = new DateTime($targetDate);
                                                $interval = $currentDate->diff($endDate);
                                                $daysDifference = (int) $interval->format('%r%a');

                                                if ($daysDifference < 0) {
                                                    $outClass = 'fw-bold text-danger';
                                                    $outText = "Abgeflogen";
                                                } elseif ($daysDifference >= 0 && $daysDifference < 10) {
                                                    $outClass = 'fw-bold text-warning';
                                                    $outText = "Noch <b>" . $daysDifference + 1 . "</b> Tage";
                                                } else {
                                                    $outClass = '';
                                                    $outText = "Noch <b>" . $daysDifference + 1 . "</b> Tage";
                                                }

                                                echo "<td class='text-start $outClass' data-bs-toggle='tooltip' data-bs-html='true' data-bs-placement='left' title='" . $outText . "'>" . htmlspecialchars($IdentityCivil['IdentityOUT']) . "</td>";

                                                echo "<td class='text-start'>";
                                                if (getPositionDetails('OwnerAccessCard', $IdentityCivil['AccessCard'], 'ID')) {
                                                    echo "<a href='/identities/position?id=" . getPositionDetails('OwnerAccessCard', $IdentityCivil['AccessCard'], 'ID') . "' class='fw-bold'>" . getPositionDetails('OwnerAccessCard', $IdentityCivil['AccessCard'], 'PositionName') . " - " . getPositionDetails('OwnerAccessCard', $IdentityCivil['AccessCard'], 'Department') . "</a>";
                                                } elseif (getPositionDetails('SuccessorAccessCard', $IdentityCivil['AccessCard'], 'ID')) {
                                                    echo "<a href='/identities/position?id=" . getPositionDetails('SuccessorAccessCard', $IdentityCivil['AccessCard'], 'ID') . "' class='fw-bold'>" . getPositionDetails('SuccessorAccessCard', $IdentityCivil['AccessCard'], 'PositionName') . " - " . getPositionDetails('SuccessorAccessCard', $IdentityCivil['AccessCard'], 'Department') . "</a>";
                                                }
                                                echo "</td>";

                                                echo "<td class='text-start'>";
                                                if ($IdentityCivil['AccessCard']) {
                                                    echo "<span class='btn btn-sm btn-outline-secondary me-2'><i class='btn-icon-prepend mdi mdi-credit-card-outline me-1'></i>" . $IdentityCivil['AccessCard'] . "</span>";
                                                }
                                                echo "</td>";

                                                echo "<td class='text-end'><a href='/identities/identity?id=" . htmlspecialchars($IdentityCivil['ID']) . "' class='btn btn-sm btn-inverse-light btn-icon-text' style='margin: 0px;'><i class='mdi mdi-text-box-edit'></i> Bearbeiten</a></td>";
                                                echo "</tr>";
                                            }
                                        }

                                        ?>
                                    </tbody>
                                </table>
                            </div>

                        </div>

                        <div class="tab-pane" id="identities-local" role="tabpanel" aria-labelledby="contact-line-tab">

                            <div class="table-responsive">
                                <table id="dTableIdentitiesLocal" width="100%" class="table" style="text-align: left;">
                                    <thead>
                                        <tr>
                                            <th class="text-start">Nachname</th>
                                            <th class="text-start">Vorname</th>
                                            <th class="text-start"><i class="mdi mdi-card-account-details-outline"
                                                    style="margin-right: .5rem;"></i> Ausweis-ID</th>
                                            <th class="text-start"><i class="mdi mdi-sort-calendar-ascending"
                                                    style="margin-right: .5rem;"></i> Zutritt ab</th>
                                            <th class="text-start"><i class="mdi mdi-sort-calendar-descending"
                                                    style="margin-right: .5rem;"></i> Zutritt bis</th>
                                            <th class="text-start"><i class="mdi mdi-briefcase"
                                                    style="margin-right: .5rem;"></i> Dienstposten</th>
                                            <th class="text-start"><i class="mdi mdi-card-text-outline"
                                                    style="margin-right: .5rem;"></i> Karte</th>
                                            <th><i class="mdi mdi-button-cursor" style="margin-right: .5rem;"></i>
                                                Optionen
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        <?php

                                        $sql = "SELECT * FROM Identities WHERE Type = 'Local'";
                                        $stmt = $pdo->query($sql);
                                        $IdentitiesLocal = $stmt->fetchAll();

                                        if ($IdentitiesLocal) {
                                            foreach ($IdentitiesLocal as $IdentityLocal) {

                                                echo "<tr>";
                                                echo "<td class='text-start fw-bold'>" . $IdentityLocal['Surname'] . "</td>";
                                                echo "<td class='text-start fw-bold'>" . $IdentityLocal['Givenname'] . "</td>";
                                                echo "<td class='text-start'>" . $IdentityLocal['LocalIDCard'] . "</td>";
                                                echo "<td class='text-start'>" . $IdentityLocal['IdentityIN'] . "</td>";

                                                $targetDate = $IdentityLocal['IdentityOUT'];
                                                $currentDate = new DateTime();
                                                $endDate = new DateTime($targetDate);
                                                $interval = $currentDate->diff($endDate);
                                                $daysDifference = (int) $interval->format('%r%a');

                                                if ($daysDifference < 0) {
                                                    $outClass = 'fw-bold text-danger';
                                                    $outText = "Abgelaufen";
                                                } elseif ($daysDifference >= 0 && $daysDifference < 10) {
                                                    $outClass = 'fw-bold text-warning';
                                                    $outText = "Noch <b>" . $daysDifference + 1 . "</b> Tage";
                                                } else {
                                                    $outClass = '';
                                                    $outText = "Noch <b>" . $daysDifference + 1 . "</b> Tage";
                                                }

                                                echo "<td class='text-start $outClass' data-bs-toggle='tooltip' data-bs-html='true' data-bs-placement='left' title='" . $outText . "'>" . $IdentityLocal['IdentityOUT'] . "</td>";

                                                echo "<td class='text-start'>";
                                                if (getPositionDetails('OwnerAccessCard', $IdentityLocal['AccessCard'], 'ID')) {
                                                    echo "<a href='/identities/position?id=" . getPositionDetails('OwnerAccessCard', $IdentityLocal['AccessCard'], 'ID') . "' class='fw-bold'>" . getPositionDetails('OwnerAccessCard', $IdentityLocal['AccessCard'], 'PositionName') . " - " . getPositionDetails('OwnerAccessCard', $IdentityLocal['AccessCard'], 'Department') . "</a>";
                                                } elseif (getPositionDetails('SuccessorAccessCard', $IdentityLocal['AccessCard'], 'ID')) {
                                                    echo "<a href='/identities/position?id=" . getPositionDetails('SuccessorAccessCard', $IdentityLocal['AccessCard'], 'ID') . "' class='fw-bold'>" . getPositionDetails('SuccessorAccessCard', $IdentityLocal['AccessCard'], 'PositionName') . " - " . getPositionDetails('SuccessorAccessCard', $IdentityLocal['AccessCard'], 'Department') . "</a>";
                                                }
                                                echo "</td>";

                                                echo "<td class='text-start'>";
                                                if ($IdentityLocal['AccessCard']) {
                                                    echo "<span class='btn btn-sm btn-outline-secondary me-2'><i class='btn-icon-prepend mdi mdi-credit-card-outline me-1'></i>" . $IdentityLocal['AccessCard'] . "</span>";
                                                }
                                                echo "</td>";

                                                echo "<td class='text-end'><a href='/identities/identity?id=" . $IdentityLocal['ID'] . "' class='btn btn-sm btn-inverse-light btn-icon-text' style='margin: 0px;'><i class='mdi mdi-text-box-edit'></i> Bearbeiten</a></td>";
                                                echo "</tr>";
                                            }
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>

                        </div>

                        <div class="tab-pane" id="identities-guest" role="tabpanel" aria-labelledby="profile-line-tab">

                            <div class="table-responsive">
                                <table id="dTableIdentitiesGuest" width="100%" class="table" style="text-align: left;">
                                    <thead>
                                        <tr>
                                            <th class="text-start">Nachname</th>
                                            <th class="text-start">Vorname</th>
                                            <th class="text-start"><i class="mdi mdi-sort-calendar-ascending"
                                                    style="margin-right: .5rem;"></i> Zutritt ab</th>
                                            <th class="text-start"><i class="mdi mdi-sort-calendar-descending"
                                                    style="margin-right: .5rem;"></i> Zutritt bis</th>
                                            <th class="text-start"><i class="mdi mdi-briefcase"
                                                    style="margin-right: .5rem;"></i> Dienstposten</th>
                                            <th class="text-start"><i class="mdi mdi-card-text-outline"
                                                    style="margin-right: .5rem;"></i> Karte</th>
                                            <th><i class="mdi mdi-button-cursor" style="margin-right: .5rem;"></i>
                                                Optionen
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sql = "SELECT * FROM Identities WHERE Type = 'Guest'";
                                        $stmt = $pdo->query($sql);
                                        $IdentitiesGuest = $stmt->fetchAll();

                                        if ($IdentitiesGuest) {
                                            foreach ($IdentitiesGuest as $IdentityGuest) {

                                                echo "<tr>";
                                                echo "<td class='text-start fw-bold'>" . htmlspecialchars($IdentityGuest['Surname']) . "</td>";
                                                echo "<td class='text-start fw-bold'>" . htmlspecialchars($IdentityGuest['Givenname']) . "</td>";
                                                echo "<td class='text-start'>" . htmlspecialchars($IdentityGuest['IdentityIN']) . "</td>";

                                                $targetDate = $IdentityGuest['IdentityOUT'];
                                                $currentDate = new DateTime();
                                                $endDate = new DateTime($targetDate);
                                                $interval = $currentDate->diff($endDate);
                                                $daysDifference = (int) $interval->format('%r%a');

                                                if ($daysDifference < 0) {
                                                    $outClass = 'fw-bold text-danger';
                                                    $outText = "Abgelaufen";
                                                } elseif ($daysDifference >= 0 && $daysDifference < 10) {
                                                    $outClass = 'fw-bold text-warning';
                                                    $outText = "Noch <b>" . $daysDifference + 1 . "</b> Tage";
                                                } else {
                                                    $outClass = '';
                                                    $outText = "Noch <b>" . $daysDifference + 1 . "</b> Tage";
                                                }

                                                echo "<td class='text-start $outClass' data-bs-toggle='tooltip' data-bs-html='true' data-bs-placement='left' title='" . $outText . "'>" . htmlspecialchars($IdentityGuest['IdentityOUT']) . "</td>";

                                                echo "<td class='text-start'>";
                                                if (getPositionDetails('OwnerAccessCard', $IdentityGuest['AccessCard'], 'ID')) {
                                                    echo "<a href='/identities/position?id=" . getPositionDetails('OwnerAccessCard', $IdentityGuest['AccessCard'], 'ID') . "' class='fw-bold'>" . getPositionDetails('OwnerAccessCard', $IdentityGuest['AccessCard'], 'PositionName') . " - " . getPositionDetails('OwnerAccessCard', $IdentityGuest['AccessCard'], 'Department') . "</a>";
                                                } elseif (getPositionDetails('SuccessorAccessCard', $IdentityGuest['AccessCard'], 'ID')) {
                                                    echo "<a href='/identities/position?id=" . getPositionDetails('SuccessorAccessCard', $IdentityGuest['AccessCard'], 'ID') . "' class='fw-bold'>" . getPositionDetails('SuccessorAccessCard', $IdentityGuest['AccessCard'], 'PositionName') . " - " . getPositionDetails('SuccessorAccessCard', $IdentityGuest['AccessCard'], 'Department') . "</a>";
                                                }
                                                echo "</td>";

                                                echo "<td class='text-start'>";
                                                if ($IdentityGuest['AccessCard']) {
                                                    echo "<span class='btn btn-sm btn-outline-secondary me-2'><i class='btn-icon-prepend mdi mdi-credit-card-outline me-1'></i>" . $IdentityGuest['AccessCard'] . "</span>";
                                                }
                                                echo "</td>";

                                                echo "<td class='text-end'><a href='/identities/identity?id=" . htmlspecialchars($IdentityGuest['ID']) . "' class='btn btn-sm btn-inverse-light btn-icon-text' style='margin: 0px;'><i class='mdi mdi-text-box-edit'></i> Bearbeiten</a></td>";
                                                echo "</tr>";
                                            }
                                        }

                                        ?>
                                    </tbody>
                                </table>
                            </div>

                        </div>

                    </div>

                </div>
            </div>
        </div>

    </div>

</div>

<?php include($_SERVER['DOCUMENT_ROOT'] . '/footer.inc.php'); ?>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Letzten aktiven Tab aus dem Local Storage laden
        var identitiesActiveTab = localStorage.getItem('identitiesActiveTab');
        if (identitiesActiveTab) {
            var tabTrigger = new bootstrap.Tab(document.querySelector('a[href="' + identitiesActiveTab + '"]'));
            tabTrigger.show();
        }

        // Event Listener für Tab Wechsel hinzufügen und im Local Storage speichern
        var tabLinks = document.querySelectorAll('a[data-bs-toggle="tab"]');
        tabLinks.forEach(function (tab) {
            tab.addEventListener('shown.bs.tab', function (event) {
                localStorage.setItem('identitiesActiveTab', event.target.getAttribute('href'));
            });
        });
    });
</script>